//
//  DW2010ViewController.m
//  DW2010
//
//  Created by Sushant Verma on 28/09/10 for /dev/world/2010.
//  Copyright Sushant Verma. All rights reserved.
//  www.trynull.com
//  @sushified
//

#import "DW2010ViewController.h"

#define FN_TRACE NSLog(@"[%@ %@]",NSStringFromClass(self.class),NSStringFromSelector(_cmd))
@implementation DW2010ViewController
@synthesize gameSession;
@synthesize chatService;

- (void) viewDidLoad
{
	FN_TRACE;
	GKPeerPickerController *picker = [[GKPeerPickerController alloc] init];
	picker.delegate = self;
	/*
	 * Peerpicker uses bluetooth by default. You can tell it to use bluetooth 
	 *    AND wifi by uncommenting the following line. Notes:
	 * - If you display a picker you have to support bluetooth.
	 * - Picker doesnt display peers on the LAN. You have to take care of
	 *    connection yourself that your self by querying the GKSession.
	 */
	//picker.connectionTypesMask = GKPeerPickerConnectionTypeNearby | GKPeerPickerConnectionTypeOnline;
	[picker show];	
	[picker release];
}

#pragma mark GKPeerPickerControllerDelegate functions

- (GKSession *)peerPickerController:(GKPeerPickerController *)picker
		   sessionForConnectionType:(GKPeerPickerConnectionType)type
{
	FN_TRACE;
	/*
	 * The sessionID tells the framework to find peers on the network(s) 
	 *    with the same sessionID. Passing nil tells framework to use the 
	 *    app identifier.
	 *
	 * The display name is your devices 'name' as seen by others. Passing nil
	 *    tells the framework to use your device name(same name as iTunes displays)
	 *
	 * Session modes...
	 * - Client: Broadcast for connection.
	 * - Server: Scan for avaliable connections.
	 * - Peer: Scan and broadcast. Takes abit longer to connect.
	 * 
	 */
	return [[[GKSession alloc] initWithSessionID:@"DW2010"
									 displayName:nil
									 sessionMode:GKSessionModePeer] autorelease];
}

- (void)peerPickerController:(GKPeerPickerController *)picker
			  didConnectPeer:(NSString *)peerID 
				   toSession:(GKSession *)session
{
	FN_TRACE;
	self.gameSession = session;
	
	/*
	 * The following line is easy to forget but very important.
	 * It ensures that your application can recieve data from 
	 *    other devices using the framework.
	 */
	[session setDataReceiveHandler:self
					   withContext:nil];
	//At this point, your application is ready to transmit data to other devices.
	
	//Lets start voice chat with the other device
	chatService = [[GKVoiceChatService alloc] init];
	chatService.client = self;
	
	[chatService startVoiceChatWithParticipantID:peerID
										   error:nil];
	//We are done picking a peer(and dont need anymore) so we dismiss the peer picker.
	[picker dismiss];
}

/**
 * Callback function for when data is recieved from another device.
 */
- (void) receiveData:(NSData *)data
			fromPeer:(NSString *)peer
		   inSession: (GKSession *)session 
			 context:(void *)context
{
	FN_TRACE;
	[chatService receivedData:data
			fromParticipantID:peer];
}

#pragma mark GKVoiceChatClient

- (void)voiceChatService:(GKVoiceChatService *)voiceChatService
				sendData:(NSData *)data
		 toParticipantID:(NSString *)participantID
{
	FN_TRACE;
	[gameSession sendDataToAllPeers:data
					   withDataMode:GKSendDataReliable
							  error:nil];
}

- (NSString *)participantID
{
	FN_TRACE;
	return gameSession.peerID;
}

- (void)voiceChatService:(GKVoiceChatService *)voiceChatService
didReceiveInvitationFromParticipantID:(NSString *)participantID
				  callID:(NSInteger)callID
{
	FN_TRACE;
	[voiceChatService acceptCallID:callID
							 error:nil];
}

#pragma mark Memory management

- (void)dealloc
{
	FN_TRACE;
	self.gameSession = nil;
	self.chatService = nil;
    [super dealloc];
}

@end
